--Step1: Configure the AG nodes for the distribution DB nodes
:Connect SQLAG1\INST1
sp_adddistributor @distributor = @@ServerName, @password = 'P@ssw0rd123'
Go 
:Connect SQLAG2\INST2
sp_adddistributor @distributor = @@ServerName, @password = 'P@ssw0rd123'
Go

--Step2: Configure the distribution database on the primary replica in SQL Server Always On Availability Group

:Connect SQLAG1\INST1
USE master
EXEC sp_adddistributiondb @database = 'DistributionDB', @security_mode = 1;
GO
Alter Database [DistributionDB] Set Recovery Full
Go
Backup Database [DistributionDB] to Disk = 'c:\temp\distributiondb.bak'
Go

--Step3: Verify the endpoints for an availability Group
USE [master]
GO

/****** Object:  Endpoint [Hadr_endpoint]    Script Date: 8/9/2020 11:22:23 PM ******/
CREATE ENDPOINT [Hadr_endpoint] 
	STATE=STARTED
	AS TCP (LISTENER_PORT = 5022, LISTENER_IP = ALL)
	FOR DATA_MIRRORING (ROLE = ALL, AUTHENTICATION = WINDOWS NEGOTIATE
, ENCRYPTION = REQUIRED ALGORITHM AES)
GO


--Step4: Add the distribution database in an existing availability group
:Connect SQLAG1\INST1
CREATE AVAILABILITY GROUP [DistributionDB_AG]
FOR DATABASE [DistributionDB]
REPLICA ON 'SQLAG1\INST1'
WITH (ENDPOINT_URL = N'TCP://SQLAG1.mydemosql.com:5022', 
		 FAILOVER_MODE = AUTOMATIC, 
		 AVAILABILITY_MODE = SYNCHRONOUS_COMMIT, 
		 BACKUP_PRIORITY = 50, 
		 SECONDARY_ROLE(ALLOW_CONNECTIONS = ALL), 
		 SEEDING_MODE = AUTOMATIC),
N'SQLAG2\INST2' WITH (ENDPOINT_URL = N'TCP://SQLAG2.mydemosql.com:5022', 
	 FAILOVER_MODE = AUTOMATIC, 
	 AVAILABILITY_MODE = SYNCHRONOUS_COMMIT, 
	 BACKUP_PRIORITY = 50, 
	 SECONDARY_ROLE(ALLOW_CONNECTIONS = ALL), 
	 SEEDING_MODE = AUTOMATIC);
 GO

--Step5:  Add the secondary replica in the SQL Server Always On Availability Group
 :Connect SQLAG2\INST2
ALTER AVAILABILITY GROUP [DistributionDB_AG] JOIN
GO  
ALTER AVAILABILITY GROUP [DistributionDB_AG] GRANT CREATE ANY DATABASE
Go

--Step 6: Create the SQL Listener for the distribution database availability group
:Connect SQLAG1\INSt1

USE [master]
GO
ALTER AVAILABILITY GROUP [DistributionDB_AG]
ADD LISTENER N'DistributionReplLSQList' (
WITH IP
((N'10.0.2.99', N'255.255.255.0')) , PORT=1899);
GO

--Step7: Enable the secondary SQL Server Always On Availability Group replica for the distributor
:CONNECT SQLAG2\INST2
EXEC sp_adddistributiondb @database = 'DistributionDB', @security_mode = 1;
GO

--Step8: Configure the publisher to use the distribution database in SQL Server Always On Availability Group

:CONNECT SQLAG1\INST1
EXEC sp_addDistPublisher @publisher = 'SQLNode3\INST3', @distribution_db = 'DistributionDB', 
	@working_directory = '\\sqlag2\sqlshare\'
GO



:CONNECT SQLAG2\INST2
EXEC sp_addDistPublisher @publisher = 'SQLNode3\INST3', @distribution_db = 'DistributionDB', 
	@working_directory = '\\sqlag2\sqlshare\''
GO

--Step9: Configure the publisher server

:CONNECT SQLNODE3\INST3
EXEC sp_addDistributor @distributor = 'DistributionReplLSQList', -- Listener for the Distribution DB.	
	@password = 'P@ssw0rd123'
Go

--Step11: Create a linked server on the primary and secondary replica
USE [master]
GO
EXEC master.dbo.sp_addlinkedserver @server = N'SQLNODE3\INST3', @srvproduct=N'SQL Server'
GO
